//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property description "DEMO Indicator"
//+------------------------------------------------------------------+
const struct stAverange
{
    int            nPeriods;
    ENUM_MA_METHOD Method;
    color          cor;
}Averange[] = 
{
    {9, MODE_EMA, clrRed},
    {20, MODE_SMA, clrGreen},
};
//+----------------+
#property indicator_chart_window
#property indicator_applied_price   PRICE_CLOSE
#property indicator_buffers         Averange.Size();
#property indicator_plots           Averange.Size();
//+------------------------------------------------------------------+
struct stInfos
{
    double  Buff_iMA[],
            f_Expo;
}Infos[Averange.Size()];
//+------------------------------------------------------------------+
int OnInit(void)
{
    for (uint c = 0; c < Averange.Size(); c++)
    {
        SetIndexBuffer(c, Infos[c].Buff_iMA, INDICATOR_DATA);
        Infos[c].f_Expo = (double) (2.0 / (1.0 + Averange[c].nPeriods));
        PlotIndexSetInteger(c, PLOT_DRAW_TYPE, DRAW_LINE);
        PlotIndexSetInteger(c, PLOT_LINE_STYLE, STYLE_SOLID);
        PlotIndexSetInteger(c, PLOT_LINE_WIDTH, 2);
        PlotIndexSetInteger(c, PLOT_LINE_COLOR, Averange[c].cor);
        PlotIndexSetString(c, PLOT_LABEL, StringFormat("%s of %d", (Averange[c].Method == MODE_EMA ? "Exponential" : "Arithmetica"), Averange[c].nPeriods));
    }

       return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
    int c0 = 0;

    for (uint c = 0; c < Averange.Size(); c++)
    {
        if (prev_calculated == 0)
        {
            double loc = 0;
            for (int c1 = 0; c1 < Averange[c].nPeriods; c1++) loc += price[Averange[c].nPeriods - c1];
            Infos[c].Buff_iMA[Averange[c].nPeriods] = loc / Averange[c].nPeriods;
        }
        switch (Averange[c].Method)
        {
            case MODE_EMA:
                for (c0 = (prev_calculated > 0 ? prev_calculated - 1 : 0); c0 < rates_total; c0++)
                    Infos[c].Buff_iMA[c0] = (c0 > 0 ? (((price[c0] - Infos[c].Buff_iMA[c0 - 1])) * Infos[c].f_Expo) + Infos[c].Buff_iMA[c0 - 1] : Infos[c].Buff_iMA[c0]);
                break;
            case MODE_SMA:
                for (c0 = (prev_calculated > 0 ? prev_calculated - 1 : Averange[c].nPeriods + 1); c0 < rates_total; c0++)
                    Infos[c].Buff_iMA[c0] = ((Infos[c].Buff_iMA[c0 - 1] * Averange[c].nPeriods) - price[c0 - Averange[c].nPeriods] + price[c0]) / Averange[c].nPeriods;
                break;
        }
    }

    return rates_total;
};
//+------------------------------------------------------------------+